<?php

namespace App\Http\Controllers\SuperAdmin;

use App\Exports\SuperAdmin\TherapistCommunityBroadcastsExport;
use App\Http\Controllers\Controller;
use App\Http\Requests\SuperAdmin\TherapistCommunityBroadcasts\CreateRequest;
use App\Http\Requests\ImportRequest;
use App\Imports\SuperAdmin\TherapistCommunityBroadcastsImport;
use App\Models\Broadcast;
use App\Models\TherapistCommunity;
use App\Models\Tag;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Str;

class TherapistCommunityBroadcastsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    /********* Initialize Permission based Middlewares  ***********/
    public function __construct()
    {
        $this->middleware('permission:therapist_community.add_media');
        $this->middleware('permission:therapist_community.add_media', ['only' => ['store']]);
        $this->middleware('permission:therapist_community.add_media', ['only' => ['update']]);
        $this->middleware('permission:therapist_community.add_media', ['only' => ['destroy']]);
        $this->middleware('permission:therapist_community.add_media', ['only' => ['export']]);
        $this->middleware('permission:therapist_community.add_media', ['only' => ['import']]);
    }
    /********* Getter For Pagination, Searching And Sorting  ***********/
    public function getter($req = null, $export = null, $therapist_community)
    {
        if ($req != null) {
            $therapist_community_broadcasts =  $therapist_community->therapist_community_broadcasts();
            if ($req->trash && $req->trash == 'with') {
                $therapist_community_broadcasts =  $therapist_community_broadcasts->withTrashed();
            }
            if ($req->trash && $req->trash == 'only') {
                $therapist_community_broadcasts =  $therapist_community_broadcasts->onlyTrashed();
            }
            if ($req->column && $req->column != null && $req->search != null) {
                $therapist_community_broadcasts = $therapist_community_broadcasts->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {

                $therapist_community_broadcasts = $therapist_community_broadcasts->whereLike(['name', 'description'], $req->search);
            }
            if ($req->sort_field != null && $req->sort_type != null) {
                $therapist_community_broadcasts = $therapist_community_broadcasts->OrderBy($req->sort_field, $req->sort_type);
            } else {
                $therapist_community_broadcasts = $therapist_community_broadcasts->OrderBy('id', 'desc');
            }
            if ($export != null) { // for export do not paginate
                $therapist_community_broadcasts = $therapist_community_broadcasts->get();
                return $therapist_community_broadcasts;
            }
            $therapist_community_broadcasts = $therapist_community_broadcasts->get();
            return $therapist_community_broadcasts;
        }
        $therapist_community_broadcasts = $therapist_community->therapist_community_broadcasts()->withAll()->orderBy('id', 'desc')->get();
        return $therapist_community_broadcasts;
    }


    /*********View All TherapistCommunityBroadcasts  ***********/
    public function index(Request $request, TherapistCommunity $therapist_community)
    {
        $therapist_community_broadcasts = $this->getter($request, null, $therapist_community);
        return view('super_admins.therapist_communitys.therapist_community_broadcasts.index', compact('therapist_community_broadcasts', 'therapist_community'));
    }

    /*********View Create Form of Broadcast  ***********/
    public function create(TherapistCommunity $therapist_community)
    {
        $tags = Tag::active()->get();
        return view('super_admins.therapist_communitys.therapist_community_broadcasts.create', compact('therapist_community', 'tags'));
    }

    /*********Store Broadcast  ***********/
    public function store(CreateRequest $request, TherapistCommunity $therapist_community)
    {
        $data = $request->all();
        try {
            DB::beginTransaction();
            if (!$request->is_active) {
                $data['is_active'] = 0;
            }
            if ($request->link_type == 'internal' && $request->file_type == 'audio') {
                $data['audio'] = uploadFile($request, 'file', 'therapist_community_broadcasts');
            } else {
                $data['video'] = uploadFile($request, 'file', 'therapist_community_broadcasts');
            }
            //$data['image'] = uploadCroppedFile($request,'image','therapist_community_broadcasts');
            $therapist_community_broadcast = $therapist_community->therapist_community_broadcasts()->create($data);
            $therapist_community_broadcast->slug = Str::slug($therapist_community_broadcast->name . ' ' . $therapist_community_broadcast->id, '-');
            $therapist_community_broadcast->save();
            $therapist_community_broadcast->tags()->sync($request->tag_ids);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            return redirect()->route('super_admin.therapist_community_broadcasts.index', $therapist_community->id)->with('message', 'Something Went Wrong')->with('message_type', 'error');
        }
        return redirect()->route('super_admin.therapist_community_broadcasts.index', $therapist_community->id)->with('message', 'Broadcast Created Successfully')->with('message_type', 'success');
    }

    /*********View Broadcast  ***********/
    public function show(TherapistCommunity $therapist_community, Broadcast $therapist_community_broadcast)
    {
        if ($therapist_community->id != $therapist_community_broadcast->therapist_community_id) {
            return redirect()->back()->with('message', 'Broadcast Not Found')->with('message_type', 'error');
        }
        return view('super_admins.therapist_communitys.therapist_community_broadcasts.show', compact('therapist_community_broadcast', 'therapist_community'));
    }

    /*********View Edit Form of Broadcast  ***********/
    public function edit(TherapistCommunity $therapist_community, Broadcast $therapist_community_broadcast)
    {
        if ($therapist_community->id != $therapist_community_broadcast->therapist_community_id) {
            return redirect()->back()->with('message', 'Broadcast Not Found')->with('message_type', 'error');
        }
        return view('super_admins.therapist_communitys.therapist_community_broadcasts.edit', compact('therapist_community_broadcast', 'therapist_community'));
    }

    /*********Update Broadcast  ***********/
    public function update(CreateRequest $request, TherapistCommunity $therapist_community, Broadcast $therapist_community_broadcast)
    {
        if ($therapist_community->id != $therapist_community_broadcast->therapist_community_id) {
            return redirect()->back()->with('message', 'Broadcast Not Found')->with('message_type', 'error');
        }
        $data = $request->all();
        try {
            DB::beginTransaction();
            if (!$request->is_active) {
                $data['is_active'] = 0;
            }
            if ($request->link_type == 'internal' && $request->file_type == 'audio') {
                if ($request->file) {
                    $data['audio'] = uploadFile($request, 'file', 'therapist_community_broadcasts');
                } else {
                    $data['audio'] = $therapist_community_broadcast->audio;
                }
            } else {
                if ($request->file) {
                    $data['video'] = uploadFile($request, 'file', 'therapist_community_broadcasts');
                } else {
                    $data['video'] = $therapist_community_broadcast->video;
                }
            }
            $therapist_community_broadcast->update($data);
            $therapist_community_broadcast = Broadcast::find($therapist_community_broadcast->id);
            $slug = Str::slug($therapist_community_broadcast->name . ' ' . $therapist_community_broadcast->id, '-');
            $therapist_community_broadcast->update([
                'slug' => $slug
            ]);
            $therapist_community_broadcast->tags()->sync($request->tag_ids);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            return redirect()->route('super_admin.therapist_community_broadcasts.index', $therapist_community->id)->with('message', 'Something Went Wrong')->with('message_type', 'error');
        }
        return redirect()->route('super_admin.therapist_community_broadcasts.index', $therapist_community->id)->with('message', 'Broadcast Updated Successfully')->with('message_type', 'success');
    }

    /********* Export  CSV And Excel  **********/
    public function export(Request $request)
    {
        $therapist_community_broadcasts = $this->getter($request, "export");
        if (in_array($request->export, ['csv,xlsx'])) {
            $extension = $request->export;
        } else {
            $extension = 'xlsx';
        }
        $filename = "therapist_community_broadcasts." . $extension;
        return Excel::download(new TherapistCommunityBroadcastsExport($therapist_community_broadcasts), $filename);
    }
    /********* Import CSV And Excel  **********/
    public function import(ImportRequest $request)
    {
        $file = $request->file('file');
        Excel::import(new TherapistCommunityBroadcastsImport, $file);
        return redirect()->back()->with('message', 'Broadcast Categories imported Successfully')->with('message_type', 'success');
    }


    /*********Soft DELETE Broadcast ***********/
    public function destroy(TherapistCommunity $therapist_community, Broadcast $therapist_community_broadcast)
    {
        if ($therapist_community->id != $therapist_community_broadcast->therapist_community_id) {
            return redirect()->back()->with('message', 'Broadcast Not Found')->with('message_type', 'error');
        }
        $therapist_community_broadcast->delete();
        return redirect()->back()->with('message', 'Broadcast Deleted Successfully')->with('message_type', 'success');
    }

    /*********Permanently DELETE Broadcast ***********/
    public function destroyPermanently(Request $request, TherapistCommunity $therapist_community, $therapist_community_broadcast)
    {
        $therapist_community_broadcast = Broadcast::withTrashed()->find($therapist_community_broadcast);
        if ($therapist_community_broadcast) {
            if ($therapist_community_broadcast->trashed()) {
                if ($therapist_community_broadcast->image && file_exists(public_path($therapist_community_broadcast->image))) {
                    unlink(public_path($therapist_community_broadcast->image));
                }
                $therapist_community_broadcast->forceDelete();
                return redirect()->back()->with('message', 'Broadcast Deleted Successfully')->with('message_type', 'success');
            } else {
                return redirect()->back()->with('message', 'Broadcast is Not in Trash')->with('message_type', 'error');
            }
        } else {
            return redirect()->back()->with('message', 'Broadcast Not Found')->with('message_type', 'error');
        }
    }
    /********* Restore Broadcast***********/
    public function restore(Request $request, TherapistCommunity $therapist_community, $therapist_community_broadcast)
    {
        $therapist_community_broadcast = Broadcast::withTrashed()->find($therapist_community_broadcast);
        if ($therapist_community_broadcast->trashed()) {
            $therapist_community_broadcast->restore();
            return redirect()->back()->with('message', 'Broadcast Restored Successfully')->with('message_type', 'success');
        } else {
            return redirect()->back()->with('message', 'Broadcast Not Found')->with('message_type', 'error');
        }
    }
}
